/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.cyclepaintings_common_forge.util;

import com.natamus.cyclepaintings_common_forge.config.ConfigHandler;
import com.natamus.cyclepaintings_common_forge.data.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.world.entity.decoration.PaintingVariant;

public class Util {
    private static final List<Holder<PaintingVariant>> allPaintingVariants = new ArrayList<Holder<PaintingVariant>>();

    public static void setPaintings(Registry<PaintingVariant> paintingRegistry) {
        if (!allPaintingVariants.isEmpty()) {
            return;
        }
        String[] allignore = ConfigHandler.ignorePaintingsInCycleResourceLocation.split(",");
        boolean debug = ConfigHandler.showRegisteredPaintingsDebug;
        if (debug) {
            Constants.logger.info("[Cycle Paintings Debug] The config option 'showRegisteredPaintingsDebug' has been enabled. Showing paintings during cycle registration.");
        }
        for (Holder paintingVariantHolder : paintingRegistry.m_206058_(PaintingVariantTags.f_215870_)) {
            ResourceKey resourceKey;
            ResourceLocation resourceLocation;
            Optional optional = paintingVariantHolder.m_203543_();
            if (optional.isEmpty() || (resourceLocation = (resourceKey = (ResourceKey)optional.get()).m_135782_()) == null) continue;
            boolean allowed = true;
            String stringLocation = resourceLocation.toString().toLowerCase();
            for (String toignore : allignore) {
                if ((toignore = toignore.toLowerCase().trim()).contains(":")) {
                    if (!stringLocation.equals(toignore)) continue;
                    allowed = false;
                    break;
                }
                if (!stringLocation.split(":")[0].contains(toignore)) continue;
                allowed = false;
                break;
            }
            if (!allowed) {
                if (!debug) continue;
                Constants.logger.info("[Cycle Paintings Debug] " + stringLocation + " (ignored)");
                continue;
            }
            if (debug) {
                Constants.logger.info("[Cycle Paintings Debug] " + stringLocation + " (allowed)");
            }
            PaintingVariant motive = (PaintingVariant)paintingRegistry.m_7745_(resourceLocation);
            allPaintingVariants.add((Holder<PaintingVariant>)paintingRegistry.m_206081_(resourceKey));
        }
    }

    public static List<Holder<PaintingVariant>> getSimilarArt(PaintingVariant currentVariant) {
        ArrayList<Holder<PaintingVariant>> similarVariants = new ArrayList<Holder<PaintingVariant>>();
        int xSize = currentVariant.m_218908_();
        int ySize = currentVariant.m_218909_();
        for (Holder<PaintingVariant> paintingVariantHolder : allPaintingVariants) {
            PaintingVariant paintingVariant = (PaintingVariant)paintingVariantHolder.m_203334_();
            if (paintingVariant.m_218908_() != xSize || paintingVariant.m_218909_() != ySize) continue;
            similarVariants.add(paintingVariantHolder);
        }
        return similarVariants;
    }
}

